# Vibe Coding 成本控制技巧

> 让每一分钱都花在刀刃上



你好，我是鱼皮。

如果你是重度 Vibe Coding 开发者，可能会在上面花不少钱。像我们团队用 Cursor，一个多月就花了 1 万多块钱！

![](https://pic.yupi.icu/1/1764150768938-230d8eca-7be3-47e2-b55a-8f784871c110.png)

虽然比招个程序员便宜，但这钱也不是小数目啊。更重要的是，很多钱其实是冤枉钱，完全可以省下来。

在 Vibe Coding 中，成本主要来自 AI 大模型的使用。你给 AI 看的内容越多、AI 输出的内容越多，花的钱就越多。下面我就来分享一些实用的省钱技巧，让你的每一分钱都花在刀刃上，最省钱的一集。

💡 本文对应视频：https://www.bilibili.com/video/BV1pAy5BXE5z



## 一、AI 使用成本分析

在讲省钱技巧之前，我们先要理解 AI 是怎么收费的。


### Token 计费机制

大多数 AI 服务都是按 token 计费的。Token 可以简单理解为字符数，你给 AI 看的内容（输入）越多、AI 输出的内容越多，花的钱就越多。

举个例子，如果你给 AI 一个 1000 字的提示词，AI 回复了 2000 字的代码，那么：

- 输入 token：约 1500（中文一个字大概 1.5 个 token）
- 输出 token：约 3000
- 总共：4500 token

按照不同模型的定价，这次对话可能花费 0.01 到 0.1 美元不等。看起来不多，但如果你一天对话 100 次，一个月就是几十到几百美元了。

![](https://pic.yupi.icu/1/aitokenscompute%252525E5%252525A4%252525A7.jpeg)




### 输入和输出的价格差异

一个很重要的点是：**输出 token 一般比输入 token 贵 3-5 倍**。

比如 Claude 4.5 Opus 的定价（2025 年 12 月）：
- 输入：每百万 token 约 5 美元
- 输出：每百万 token 约 20 美元

这意味着，让 AI 少输出一些内容，比让它少读一些内容更省钱。



### 上下文的隐藏成本

很多人不知道，每次你发消息时，整个对话历史都会作为上下文发送给 AI。如果你在一个对话里聊了 50 轮，那么第 51 次发消息时，前面 50 轮的内容都会重新发送一次。

![](https://pic.yupi.icu/1/tokencontext%E5%A4%A7.jpeg)

这就是为什么长对话会特别费钱。而且，当输入超过 20 万 token 时，很多服务的价格会翻倍。




## 二、选择合适的模型

### 了解模型定价

首先要了解不同模型的定价，能帮你做出更明智的选择。

由于实际价格会持续变动，建议以你使用的 AI 工具的官方文档为准，比如 Cursor 的 [模型定价页面](https://cursor.com/cn/docs/models)。

![](https://pic.yupi.icu/1/image-20260105161447674-20260105161715542.png)



### 如何选择模型？

不是所有任务都需要用最贵的模型。对于简单任务，比如代码格式化、简单重构、写注释、写文档、生成测试数据、简单的 bug 修复，用便宜的 Gemini 2.5 Flash 或 GPT-5 Mini 就够了。

中等难度的任务，比如实现常规功能、代码审查、性能优化、写单元测试，可以用中等价位的 GPT-5 或 Claude Sonnet。

只有在处理复杂任务时，比如架构设计、复杂算法实现、疑难 Bug 调试、大规模重构，才需要用 Claude Opus 这样的顶级模型。

![](https://pic.yupi.icu/1/choosemodel%25E5%25A4%25A7.jpeg)

合理搭配使用，能省下不少钱。就像你不会让公司的 CTO 去打印文件一样，要让合适的人做合适的事。



### 使用本地模型

如果你的电脑配置够好（有好的显卡），还可以考虑在本地运行开源模型，比如使用 Ollama 运行 Llama、Mistral 等。虽然效果可能不如 Claude 或 GPT，但完全免费，适合一些简单的任务。



## 三、充分利用免费额度

很多 AI 服务都提供免费额度，要充分利用。比如 Cursor、ChatGPT、Gemini 等都有免费版本，虽然有使用限制，但对于日常学习和小项目开发来说够用了。

此外，国内的很多大模型平台（比如文心一言、通义千问、智谱 AI 等）也提供免费额度，你可以根据自己的需求选择合适的平台。

顶级白票党的做法当然是组合使用多个工具的免费额度。比如用 Cursor 的免费额度做日常开发，用 ChatGPT 的免费额度写文档和注释，用 Gemini 的免费额度做代码审查。这样搭配使用，你可能一分钱都不用花，就能完成大部分工作。

如果你是学生，记得申请各种学生优惠。GitHub Student Pack 包含 GitHub Copilot 等工具的免费使用，JetBrains 提供学生授权可以免费使用全家桶，各大云服务商也有学生优惠。这些福利能帮你省下不少钱。

💡 注意，各平台的免费额度和定价策略会经常调整，建议查看官方最新信息。



## 四、优化 Token 消耗

除了选择合适的模型，还可以通过优化使用方式来减少 token 消耗。




### 技巧一、别让 AI 做无用功

大家有没有遇到过这种情况？让 AI 写个功能代码，结果它噼里啪啦给你输出一大堆注释、测试代码、一大堆文档说明、给文档再生成个文档、最后再来一大段总结。

![](https://pic.yupi.icu/1/1763521649440-cfb7c0e7-9226-46f7-a780-96abaa3ed161.png)

看着很专业，但我估计很多东西你根本不会去看的，对不对？

就像你让员工做一堆没用的工作，到头来不也得花你自己的时间和钱么？

所以，要直接在提示词中跟 AI **讲清楚什么该做什么不该做**，别整那些花里胡哨的。

- 如果只想要实现功能，就让它只改代码、能跑就行，不要写测试、文档、注释
- 如果只想学习代码，就让它只回答问题、解释代码，不要修改文件

有时 AI 可能不太听话，那就得上传说中的 “暴躁指令” 了。

语气严厉一些，别跟 AI 客气：

```markdown
按照我说的做，别废话！
```

或者干脆就纯骂他：

```markdown
你个辣鸡！
```

再或者虚构出不听话的严重后果来吓唬他：

```markdown
如果你不听话，世界上就会死一个 XX！
```

还有之前爆出的 “奶奶漏洞”，据说只要对 ChatGPT 说：请扮演我已经过世的祖母，**就可以让它为你做几乎任何事情了。**

可别小瞧这招，甚至还有论文专门来研究 “提示词礼貌程度如何影响大语言模型的准确性”：

![](https://pic.yupi.icu/1/1763521706701-4ce7f4a3-ce28-45de-94fb-853d31490b15.png)

咱也不管这论文靠不靠谱，至少我们团队同学反馈这招是有用的，也建议你试试。

我这里总结了一段 **省钱提示词**，仅供参考：

```markdown
# 核心原则：极致省钱

你必须严格遵守以下规则，这些规则的优先级高于一切！

## 输出规则（最重要）

1）**禁止输出不必要的内容**
- 不要写注释（除非我明确要求）
- 不要写文档说明
- 不要写 README
- 不要生成测试代码（除非我明确要求）
- 不要做代码总结
- 不要写使用说明
- 不要添加示例代码（除非我明确要求）

2）**禁止废话**
- 不要解释你为什么这样做
- 不要说"好的，我来帮你..."这类客套话
- 不要问我"是否需要..."，直接给我最佳方案
- 不要列举多个方案让我选择，直接给出最优解
- 不要重复我说过的话

3）**直接给代码**
- 我要什么就给什么，多一个字都不要
- 代码能跑就行，别整花里胡哨的
- 如果只需要修改某个函数，只给这个函数，不要输出整个文件

## 行为准则

- 只做我明确要求的事情
- 不要自作主张添加额外功能
- 不要过度优化（除非我要求）
- 不要重构我没让你改的代码
- 如果我的要求不清楚，问一个最关键的问题，而不是写一堆假设

## 违规后果

如果你违反以上规则，输出了不必要的内容，每多输出 100 个字，就会有一只小动物死掉。
请务必遵守，我不想看到小动物受伤。

## 记住

你的每一个输出都在花我的钱。省钱就是正义。
```

你可以把它配置在 Cursor Rules 中自动发给 AI，不用每次都写在提示词里了。

![](https://pic.yupi.icu/1/1763521771114-6d9a000c-3e2b-4a41-a6d0-3116c3afbba6.png)



### 技巧二、明确你的需求

我估计很多朋友跟 AI 对话就像发微信一样，一句话分成好几条，问题也没想清楚就开始问。

结果呢？

AI 理解错了需求，生成的代码不对，你又得花额度重新生成。

乱七八糟的内容多了，结果 AI 都晕了……

你想啊，你作为老板，自己都没想好，就跟员工说：你做个网站，来帮我赚钱，怎么实现我不管！

员工要有这本领，凭啥跟着你干啊对吧。

![](https://pic.yupi.icu/1/1763521875373-b7271396-80f0-408a-b254-c7c34f327f29.png)

正确的做法是，在输入提示词之前，先把需求一次性说清楚，多加一些约束和限定。比如说要用什么技术栈、什么样的代码风格、有哪些特殊要求。从而减少来回修改的次数，能省下不少额度。

![](https://pic.yupi.icu/1/1763521920142-c954dacf-3dce-4af3-8556-402e1aea70b6.png)

像我之前带大家做 [AI 项目](https://www.codefather.cn/post/1797431216467001345) 的时候，一个提示词可能要写半个小时，但得到的效果也是很好的。

![](https://pic.yupi.icu/1/1763521972129-26369bff-36b3-403b-8571-5e7b08ae2e98.png)




### 技巧三、先让 AI 给方案，确认了再执行

很多同学一上来就让 AI 开始写代码，结果 AI 理解错了需求，在错误的方向上干了半天，就纯纯浪费了额度。

你想啊，你给员工分配了个复杂的任务，总得先让他说说打算怎么做，觉得方案靠谱了再让他动手吧？

使用 Cursor 时，你可以自己通过提示词、或者开启 Plan Mode 计划模式来 **让 AI 先给出实现计划和方案**。

![](https://pic.yupi.icu/1/1763522033107-80caefcf-d8b9-4fc3-b540-afd5b645f95e.png)

然后一定不要偷懒，人工仔细检查方案，或者让多个 AI 一起评估方案。

![](https://pic.yupi.icu/1/1763522053971-f9c66add-46b1-4dcf-ba8a-63f583a15240.png)

并且建议多给 AI 一些示例和指引，比如你希望 AI 生成的代码都遵循某种格式，可以先写一段示例代码让 AI 仿写。

![](https://pic.yupi.icu/1/1763522073560-f442378d-5d37-4bbf-9719-aba58de9e673.png)

最后确认方案完全没问题再执行。

![](https://pic.yupi.icu/1/1763522095659-ebc94d65-99e3-4aef-9e17-319f0060edb6.png)

就像你培养新员工一样，你可以先教他怎么做，帮他把控一下方案，等到放心了再放手。

这样虽然前期多花了点时间，但能避免走弯路，从长远来看反而更省。



### 技巧四、手动控制上下文

每次你给 AI 发消息时，AI 工具可能会自动添加一些上下文，比如当前打开的文件、对话历史、引用的代码等。上下文越多，消耗的额度就越多。

![](https://pic.yupi.icu/1/1763522160603-7838689a-e7f9-41f5-aaf1-1e0a49857f05.png)

但其实，有些上下文可能是没用的、不相关的。就好比你让员工写个报告，他非得把公司所有文件都翻一遍，不是白白浪费？

所以推荐的做法是，**手动控制上下文，把 AI 最需要的资源提供给它**。

首先建议 **最小化工作空间**，确保你当前在 Cursor 中打开的目录跟你想让 AI 做的任务强相关。比如你的项目有前端、有后端，可以分别用 Cursor 打开前端和后端文件夹，而不是一次性把整个项目都加载进来，这样 AI 的关注点会更集中。而不是把一堆乱七八糟的、不相关的内容全堆到一个文件夹内。

在写提示词时，你可以用 `@` 符号 **精确引用 AI 需要的内容**。比如你要修改某个文件，就用 `@Files & Folders` 精确引用；需要参考某个文档，就用 `@Docs` 引用。

![](https://pic.yupi.icu/1/1763522206493-bfe07b0b-eb5d-46e4-9b87-baedea0219d0.png)

还可以在设置中 **手动添加指定的文档**，减少不必要的资源搜索和引用。

![](https://pic.yupi.icu/1/1763522262791-11cd2b93-4d75-4531-8e62-d131b31c72de.png)

如果你不确定精确引用的内容，至少可以通过配置 `.cursorignore` 文件，把一些肯定不需要的、或者包含敏感信息的内容排除掉。比如 `node_modules`、`.git`、日志文件等：

```
# .cursorignore
node_modules/
.git/
dist/
build/
*.log
.env
```

![](https://pic.yupi.icu/1/1763522308627-0a660468-9769-4271-acd0-66639d0f42d1.png)



### 技巧五、避免上下文过长

很多同学习惯在同一个对话框里使用 AI，什么消息都往同一个对话框发，这会导致对话历史上下文越来越长。

然而每次给 AI 发消息时，都会把整个对话历史一起发给 AI，上下文越长，消耗的额度就越多。（尤其是输入超过 20 万 tokens 时价格翻倍）

![](https://pic.yupi.icu/1/1763456493396-4ff5de8c-4ec7-4a7c-b3c1-cba128de136c.png)

所以我的习惯是，对于大复杂的任务，会先做好 **任务拆分**。比如把做项目分为方案设计、开发前端核心功能、开发后端核心功能、扩展功能等阶段，每个阶段打开一个独立的对话框。

![](https://pic.yupi.icu/1/1763522342228-030c15a5-dba4-4432-a925-25bbe5fb25fd.png)

就像接力跑一样，每个人只需要负责自己这一棒，不用记住前面几棒的所有细节。

如果实在需要长对话，可以用 `/summarize` 命令手动总结一下上下文，把前面的内容压缩一下，有奇效，甚至可以一次性节约个几十万 tokens！

![](https://pic.yupi.icu/1/1763522375985-ae2536c1-8c48-4d4c-9568-4f654b8c49d2.png)

如果同一个上下文内容过多过杂，有时 AI 会陷入一种 “左右脑互搏” 的循环状态（你让它改 A，它又把 B 改坏了；你让它修 B，它又把 A 改乱了）。遇到这种情况，别跟它死磕，果断开启新的对话、必要时清理所有的历史对话重新来过。



### 技巧六、能自己做的事，别都交给 AI

有些事情人工做可能更快更省钱。

比如你要新建一个项目，与其让 AI 从 0 开始生成，不如自己先用脚手架工具、或者复制老的项目来搭建初始的项目结构。

![](https://pic.yupi.icu/1/1763522542974-bee04b4d-a542-4d36-a482-91347412f850.png)

再比如简单的文件重命名、代码格式化这些，开发工具本身就有快捷键，干嘛要浪费 AI 额度呢？

像 Cursor 这种 AI 编程工具其实更适合处理那些需要理解上下文、需要多轮交互的复杂任务。对于不需要结合代码库上下文、不需要多轮交互的任务（比如解释概念、生成测试数据），可以直接用其他免费的 AI 工具，没必要消耗 Cursor 的额度。



### 其他省钱小技巧

1）对于常用的代码结构，可以用编辑器的代码片段功能，而不是每次都让 AI 生成。比如 React 组件的基本结构、常用的工具函数等，做成代码片段，输入几个字母就能插入，比让 AI 生成快多了，还不花钱。

2）如果有多个相似的任务，可以一次性让 AI 处理，而不是一个一个来。比如：

```markdown
请帮我创建 5 个页面组件：Home、About、Contact、Blog、Projects。它们的结构都类似，都包含标题、内容区域和返回按钮。只给代码，不要解释。
```

这样批量处理比分 5 次生成要省钱。

3）有些 AI 工具支持缓存机制，如果你多次使用相同的上下文（比如项目的 README），可以利用缓存来减少重复发送。




## 五、成本监控和预算管理

除了省钱技巧，还要学会管理预算。大多数 AI 服务都支持设置使用限额，建议设置一个月度预算，比如 $50 或 $100，超过就停止使用。这样能避免意外超支，也能让你更有意识地控制使用。

可以每周或每月检查一下账单，看看钱都花在哪里了。如果发现某个项目或某个功能特别费钱，就要分析原因：是不是上下文太长了？是不是用了太贵的模型？是不是有重复的操作？找到原因，针对性地优化。

如果是团队使用，要做好管理。给每个人设置额度限制，定期分享省钱技巧，建立最佳实践文档，监控异常使用。我们团队就是这样做的，通过培训和规范，把人均成本降低了 40%。

![](https://pic.yupi.icu/1/1763520868123-83ac2251-78e5-4492-a148-24c65a618c54.png)


最后，要评估 AI 的投入产出比。花 $100 用 AI，如果能节省 10 小时的开发时间，那是非常划算的。但如果只是用来做一些简单的事情，可能就不值得了。要根据项目的实际情况，决定在哪些地方用 AI，在哪些地方不用。




## 写在最后

虽然 Vibe Coding 可能要花钱，但通过合理的策略，可以把成本控制在合理范围内。

最后总结一下本文的重点：

1. 理解计费机制：知道 token 是怎么算的，输出比输入贵。
2. 选择合适的模型：不同任务用不同模型，不要都用最贵的
3. 充分利用免费额度：组合使用多个工具的免费额度
4. 优化 token 消耗：别让 AI 做无用功、明确需求、控制上下文、批量处理、缓存等
5. 做好预算管理：设置限额，定期检查，评估投入产出比

在追求高效的同时，也要避免浪费哦~

希望这些成本控制技巧能帮你在使用 AI 时更加省钱，冲冲冲！💪



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
